% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence-rate.R
\name{convergence_rate}
\alias{convergence_rate}
\title{Empirical convergence rate of a KL divergence estimator}
\usage{
convergence_rate(
  estimator,
  X,
  Y = NULL,
  q = NULL,
  n.sizes = 4,
  spacing.factor = 1.5,
  typical.subsample = function(n) sqrt(n),
  B = 500L,
  plot = FALSE
)
}
\arguments{
\item{estimator}{A KL divergence estimator.}

\item{X, Y}{\code{n}-by-\code{d} and \code{m}-by-\code{d} data frames or matrices (multivariate
samples), or numeric/character vectors (univariate samples, i.e. \code{d = 1}),
representing \code{n} samples from the true distribution \eqn{P} and \code{m}
samples from the approximate distribution \eqn{Q} in \code{d} dimensions.
\code{Y} can be left blank if \code{q} is specified (see below).}

\item{q}{The density function of the approximate distribution \eqn{Q}. Either
\code{Y} or \code{q} must be specified. If the distributions are all continuous or
all discrete, \code{q} can be directly specified as the probability density/mass
function. However, for mixed continuous/discrete distributions, \code{q} must
be given in decomposed form, \eqn{q(y_c,y_d)=q_{c|d}(y_c|y_d)q_d(y_d)},
specified as a named list with field \code{cond} for the conditional density
\eqn{q_{c|d}(y_c|y_d)} (a function that expects two arguments \code{y_c} and
\code{y_d}) and \code{disc} for the discrete marginal density \eqn{q_d(y_d)} (a
function that expects one argument \code{y_d}). If such a decomposition is not
available, it may be preferable to instead simulate a large sample from
\eqn{Q} and use the two-sample syntax.}

\item{n.sizes}{Number of different subsample sizes to use (default: \code{4}).}

\item{spacing.factor}{Multiplicative factor controlling the spacing of sample
sizes (default: \code{1.5}).}

\item{typical.subsample}{A function that produces a typical subsample size,
used as the geometric mean of subsample sizes (default: \code{sqrt(n)}).}

\item{B}{Number of subsamples to draw per subsample size.}

\item{plot}{A boolean (default: \code{FALSE}) controlling whether to produce a
diagnostic plot visualizing the fit.}
}
\value{
A scalar, the parameter \eqn{\beta} in the empirical convergence
rate \eqn{n^-\beta} of the \code{estimator} to the true KL divergence.
It can be used in the \code{convergence.rate} argument of \code{kld_ci_subsampling()}
as \code{convergence.rate = function(n) n^beta}.
}
\description{
Subsampling-based confidence intervals computed by \code{kld_ci_subsampling()}
require the convergence rate of the KL divergence estimator as an input. The
default rate of \code{0.5} assumes that the variance term dominates the bias term.
For high-dimensional problems, depending on the data, the convergence rate
might be lower. This function allows to empirically derive the convergence
rate.
}
\details{
References:

Politis, Romano and Wolf, "Subsampling", Chapter 8 (1999), for theory.

The implementation has been adapted from lecture notes by C. J. Geyer,
https://www.stat.umn.edu/geyer/5601/notes/sub.pdf
}
\examples{
    # NN method usually has a convergence rate around 0.5:
    set.seed(0)
    convergence_rate(kld_est_nn, X = rnorm(1000), Y = rnorm(1000, mean = 1, sd = 2))

}
