% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kld-analytical.R
\name{kld_uniform}
\alias{kld_uniform}
\title{Analytical KL divergence for two uniform distributions}
\usage{
kld_uniform(a1, b1, a2, b2)
}
\arguments{
\item{a1, b1}{Range of true uniform distribution}

\item{a2, b2}{Range of approximate uniform distribution}
}
\value{
A scalar (the Kullback-Leibler divergence)
}
\description{
This function computes \eqn{D_{KL}(p||q)}, where \eqn{p\sim \text{U}(a_1,b_1)}
and \eqn{q\sim \text{U}(a_2,b_2)}, with \eqn{a_2<a_1<b_1<b_2}.
}
\examples{
kld_uniform(a1 = 0, b1 = 1, a2 = 0, b2 = 2)
}
