% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_eigenvalues.R
\name{calc_eigenvalues}
\alias{calc_eigenvalues}
\title{Calculate Eigenvalues}
\usage{
calc_eigenvalues(data)
}
\arguments{
\item{data}{A covariance matrix made with \code{covar_mtrx()} function, or a
A dataset of class data.frame. The data should contain 'C_X' and 'C_Y' columns
representing the x and y coordinates of the data points and excludes any rank,
ID, or column not for analysis.}
}
\value{
A data frame with two columns: "Evalues_COV" and "pc.names1".
"Evalues_COV" represents the eigenvalues for each principal component
listed in "pc.names1".
}
\description{
This function calculates the eigenvalues of a given covariance matrix
or a klovan dataset. In case of a klovan dataset, it is first converted
into a covariance matrix. For further details on klovan datasets, refer to the README.
}
\examples{
data("Klovan_Row80")
calc_eigenvalues(covar_mtrx(Klovan_Row80)) # view eigenvalues

}
