% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kriging.R
\name{kriging}
\alias{kriging}
\title{Perform Kriging Interpolation}
\usage{
kriging(
  data,
  factor,
  grid_cell_size = NA,
  nugget,
  sill,
  range_val,
  a,
  model_name
)
}
\arguments{
\item{data}{A dataset of class data.frame. The data should contain 'C_X' and 'C_Y' columns
representing the x and y coordinates of the data points and excludes any rank,
ID, or column not for analysis, see README for details}

\item{factor}{The target factor (FAC) to be interpolated using kriging.}

\item{grid_cell_size}{The desired cell size for the grid. Default is NA, which will calculate the cell size based on the average distance between data points.}

\item{nugget}{The nugget effect parameter for the variogram model.}

\item{sill}{The sill parameter for the variogram model.}

\item{range_val}{The range parameter for the variogram model.}

\item{a}{Additional parameter (depends on the variogram model) use NA if not needed.}

\item{model_name}{The name of the model to use for variogram fitting and kriging. Options include
"Sph1", "Exp1", "Gau1", "Mat1", "Pow1", "Quad1", "Card1", "Gam1", "Cau1", "Sta1", "Ord1", "Tri1", and "Cos1".
use function\code{print_model_names()} for more information}
}
\value{
A data frame containing the interpolated values for the target factor (FAC).
}
\description{
This function performs kriging interpolation on spatial data using ridge regression to calculate
the kriging weights. It uses either regular inverse or generalized inverse with ridge regression
based on the availability of regular inverse for the given covariance matrix.
}
\examples{
data(Klovan_Row80)
# Perform kriging interpolation for FAC1
kriging_results <- kriging(Klovan_Row80, factor = 1, grid_cell_size = NA,
nugget=.0001, sill=2.5, range_val=1000, a=NA, model_name="Sph1")

}
