% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{count_substring_fixed}
\alias{count_substring_fixed}
\title{Count sequence content in a given sequence.}
\usage{
count_substring_fixed(sequence, start, end, pattern)
}
\arguments{
\item{sequence}{A sequence to map.}

\item{start}{Start positions.}

\item{end}{End positions.}

\item{pattern}{A pattern to search for.}
}
\value{
A numeric vector of count.
}
\description{
stringi has no function that search within substring without memory copy it.
This function has two versions. One without the need to memory copy denoted
as ***. The only downside to this is std::string::find cannot stop searching
past end of substring. I manage to at least stop it as soon as possible. If
the pattern is long and rare, it won't stop until it find post-substring
pattern. The other version is memory copy substring but as this operation is
in the loop, the memory is still within comfortable range. c++17 has
std::string_view that solve this but still new and not widely available. Use
count_substring_regex to avoid memory copy.
}
