\name{plot.histde}
\alias{plot.histde}
\title{Plot for histogram density estimate}

\description{
  Plot for histogram density estimate for 1- and 2-dimensional data.
}

\usage{
\method{plot}{histde}(x, ...)
}

\arguments{
  \item{x}{object of class \code{histde} (output from \code{\link{histde}})}
  \item{...}{other graphics parameters:
    \describe{
      \item{\code{col}}{plotting colour for density estimate}
      \item{\code{col.fun}}{plotting colour function for levels}
      \item{\code{col.pt}}{plotting colour for data points}
      \item{\code{jitter}}{flag to jitter rug plot (1-d). Default is TRUE.}
      \item{\code{xlim,ylim}}{axes limits}
      \item{\code{xlab,ylab}}{axes labels}
      \item{\code{add}}{flag to add to current plot. Default is FALSE.}
      \item{\code{drawpoints}}{flag to draw data points on density estimate. Default is FALSE.}
      \item{\code{breaks}}{vector of break values of density estimate. Default is an \code{nbreaks} equilinear sequence over the data range.}
      \item{\code{nbreaks}}{number of breaks in \code{breaks} sequence}
      \item{\code{lty.rect},\code{lwd.rect}}{line type/width for histogram box lines (2-d)}
      \item{\code{border}}{colour of histogram box lines (2-d)}
      \item{\code{col.rect}}{colour of histogram bars (1-d)}
      \item{\code{add.grid}}{flag to add histogram grid (2-d). Default is TRUE.}
    }
  }
}
  
\value{
  Plots for 1-d and 2-d are sent to graphics window. 
}

\details{
  For \code{histde} objects, the function headers for the different dimensional data are  
  \preformatted{
  ## univariate
  plot(fhat, xlab, ylab="Density function", add=FALSE, drawpoints=FALSE,
     col.pt=4, jitter=FALSE, border=1, alpha=1, ...) 
  
  ## bivariate
  plot(fhat, breaks, nbreaks=11, xlab, ylab, zlab="Density function", cex=1, 
     pch=1, add=FALSE, drawpoints=FALSE, col, col.fun, alpha=1, col.pt=4,
     lty.rect=2, cex.text=1, border, lwd.rect=1, col.rect="transparent",
     add.grid=TRUE, ...)}

  The 1-d plot is a standard plot of a histogram generated by \code{hist}. If
  \code{drawpoints=TRUE} then a rug plot is added.

  The 2-d plot is similar to the \code{display="filled.contour"} option from
  \code{\link{plot.kde}} with the default \code{nbreaks=11} contour
  levels. 
}

\seealso{\code{\link{plot.kde}}}
 
\examples{
## univariate example
data(iris)
fhat <- histde(x=iris[,2])
plot(fhat, xlab="Sepal length")

## bivariate example
fhat <- histde(x=iris[,2:3])
plot(fhat, drawpoints=TRUE)
box()
}

\keyword{hplot}
