% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pham.R
\name{num_clusters_all}
\alias{num_clusters_all}
\title{Get all recommended numbers of clusters}
\usage{
num_clusters_all(obj)
}
\arguments{
\item{obj}{the output of \code{kselection} function.}
}
\value{
an array of number of clusters that could be recommended.
}
\description{
The number of cluster which could be recommender according the method
threshold.
}
\examples{
# Create a data set with two clusters
dat <- matrix(c(rnorm(100, 2, .1), rnorm(100, 3, .1),
                rnorm(100, -2, .1), rnorm(100, -3, .1)), 200, 2)

# Get the optimal number of clustes
sol <- kselection(dat)
k   <- num_clusters(sol)

}
\seealso{
\code{\link{num_clusters}}, \code{\link{get_f_k}}
}
\author{
Daniel Rodriguez
}
