% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lama_translate.R
\name{check_and_translate_vector_}
\alias{check_and_translate_vector_}
\title{Checks arguments and translate a character vector (standard eval)}
\usage{
check_and_translate_vector_(.data, dictionary, translation, keep_order,
  to_factor, is_translated, err_handler)
}
\arguments{
\item{.data}{Either a data frame, a factor or an atomic vector.}

\item{dictionary}{A \link[=new_lama_dictionary]{lama_dictionary} object, holding the translations for various
variables.}

\item{translation}{A character vector holding the names of the variable
translations which
should be used for assigning new labels to the variable. This names must be
a subset of the translation names returned by \code{names(dictionary)}.}

\item{keep_order}{A boolean vector of length one or the same length as the
number of translations. If the vector has length one, then the same
configuration is applied to all variable translations. If the vector has
the same length as the number of arguments in \code{...}, then the
to each variable translation there is a corresponding boolean configuration.
If a translated variable in the data.frame is a factor variable,
and the corresponding boolean configuration is set to \code{TRUE}, then the
the order of the original factor variable will be preserved.}

\item{to_factor}{A boolean vector of length one or the same length as the
number of translations. If the vector has length one, then the same
configuration is applied to all variable translations. If the vector has
the same length as the number of arguments in \code{...}, then the
to each variable translation there is a corresponding boolean configuration.
If \code{to_factor} is \code{TRUE}, then the resulting labeled
variable will be a factor. If \code{to_factor} is set to \code{FALSE}, then
the resulting labeled variable will be a plain character vector.}

\item{is_translated}{A boolean vector of length one or the same length as the
number of translations. If the vector has length one, then the same
configuration is applied to all variable translations.
If \code{is_translated = TRUE}, then the original variable is a character
vector holding the right labels (character strings).
In this case, the labels are left unchanged, but the variables are turned
into factors with order given in the selected translations.}

\item{err_handler}{An error handling function}
}
\description{
Checks arguments and translate a character vector (standard eval)
}
