% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda-config.R
\name{get_lambda_environment_variable}
\alias{get_lambda_environment_variable}
\title{Retrieve a Lambda environment variable if available, and error otherwise}
\usage{
get_lambda_environment_variable(env_var, default = NULL)
}
\arguments{
\item{env_var}{character environment variable to retrieve}

\item{default}{character default value to return if the environment variable
is undefined. The environment variable always takes precedence.}
}
\value{
character
}
\description{
This function is provided to return a specific error if an environment
variable is not defined. This is used by \code{\link{lambda_config}} to
ensure that the environment variables that are expected to be defined by AWS
are present.

If the environment variable is undefined but a \code{default} value is provided,
then that default value will be returned. However, the environment variable
will always take precedence.
}
\keyword{internal}
