% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/trajectories.R, R/model.R
\name{plotTrajectories}
\alias{plotTrajectories}
\alias{plotTrajectories,data.frame-method}
\alias{plotTrajectories,ANY-method}
\alias{plotTrajectories,lcModel-method}
\title{Plot the data trajectories}
\usage{
plotTrajectories(object, ...)

\S4method{plotTrajectories}{data.frame}(
  object,
  response,
  cluster,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  facet = TRUE,
  ...
)

\S4method{plotTrajectories}{ANY}(object, ...)

\S4method{plotTrajectories}{lcModel}(object, ...)
}
\arguments{
\item{object}{The data or model or extract the trajectories from.}

\item{...}{Additional arguments passed to \link{trajectories}.}

\item{response}{Response variable \code{character} name or a \code{call}.}

\item{cluster}{Whether to plot trajectories grouped by cluster (determined by the "Cluster" column).
Alternatively, the name of the cluster column indicating trajectory cluster membership.
If unspecified, trajectories are grouped if the object contains a "Cluster" column.}

\item{time}{The time variable name, see \link{timeVariable}.}

\item{id}{The identifier variable name, see \link{idVariable}.}

\item{facet}{Whether to facet by cluster.}
}
\description{
Plots the output of \link{trajectories} for the given object.
}
\examples{
data(latrendData)

if (require("ggplot2")) {
  plotTrajectories(latrendData, response = "Y", id = "Id", time = "Time")

  plotTrajectories(
    latrendData,
    response = quote(exp(Y)),
    id = "Id",
    time = "Time"
  )

  plotTrajectories(
    latrendData,
    response = "Y",
    id = "Id",
    time = "Time",
    cluster = "Class"
  )
}
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData, nClusters = 3)

if (require("ggplot2")) {
  plotTrajectories(model)
}
}
\seealso{
\link{trajectories}

\link{trajectories} \link{plotFittedTrajectories} \link{plotClusterTrajectories}

\link{trajectories}
}
