% Generated by roxygen2: do not edit by hand
% Please edit documentation in www.vantharp.com/>
\name{mt_stat_transf}
\alias{mt_stat_transf}
\title{Perform Statistical transformation and clustering of Market Types on the price data}
\usage{
mt_stat_transf(
  indicator_dataset,
  num_bars = 64,
  timeframe = 60,
  path_data,
  mt_classes,
  clust_method = "kmeans",
  clust_opt = "complete",
  rule_opt = TRUE
)
}
\arguments{
\item{indicator_dataset}{Dataframe, multiple column dataset containing price data in each column.
Each row is a time index, multiple columns are required but not strictly needed}

\item{num_bars}{Integer, Number of bars used to perform transformation}

\item{timeframe}{Integer, Data timeframe in Minutes, only used for naming convention}

\item{path_data}{String, User path where the dataset could be stored for the future use by other function}

\item{mt_classes}{Character Vector, with 2 or more Market Type classes}

\item{clust_method}{Character, option to select which clustering method to choose. Could be either
'kmeans' or 'hclust'. Default value is 'kmeans'}

\item{clust_opt}{Character, option to select how to perform h clustering
"average", "single", "complete", "ward". Default value is 'complete'}

\item{rule_opt}{Boolean, option to perform rule-based Market Type Assignment, defaults to TRUE}
}
\value{
Dataframe with statistically transformed and classified dataset for classification modeling
}
\description{
Function features methods of statistical data transformation and clustering of the price data.
Multiple statistical properties are calculated for a defined time interval. Once combined,
unsupervised learning (clustering) is performed to assign several classes, see function \code{mt_make_model}.
Function allows to fully automatize financial periods classification.
It is possible to choose two clustering methods either kmeans or hierarchical clustering.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
User can define several market type classes names however function will randomly assign
Market Period labels based on Unsupervised Learning. This is inconvenient however that should be compensated by
automated way of doing such data classification
}
\examples{

library(dplyr)
library(stats)
library(magrittr)
library(readr)
library(lazytrade)

path_data <- normalizePath(tempdir(),winslash = "/")

data(price_dataset_big)

#option
#mt_classes = c('BUN', 'BEN', 'RAN','BUV', 'BEV', 'RAV')
#mt_classes = c('BUN', 'BEN', 'RAN')
#clust_method = 'hclust'
#clust_opt = 'ward'

#build dataset for Market Type detection without rule based check
ai_class_rand <- mt_stat_transf(indicator_dataset = price_dataset_big,
                                num_bars = 64,
                                timeframe = 60,
                                path_data = path_data,
                                mt_classes = c('BUN', 'BEN'),
                                clust_method = 'kmeans',
                                clust_opt = 'complete',
                                rule_opt = FALSE)

#use rule base check
ai_class_rule <- mt_stat_transf(indicator_dataset = price_dataset_big,
                                num_bars = 64,
                                timeframe = 60,
                                path_data = path_data,
                                mt_classes = c('BUN', 'BEN'),
                                clust_method = 'kmeans',
                                clust_opt = 'complete',
                                rule_opt = TRUE)


}
\author{
(C) 2021 Vladimir Zhbanko
}
