% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-render.R
\name{lcarsOutput}
\alias{lcarsOutput}
\alias{lcarsBoxOutput}
\alias{lcarsSweepOutput}
\title{Create an LCARS output (client side)}
\usage{
lcarsBoxOutput(outputId)

lcarsSweepOutput(outputId)
}
\arguments{
\item{outputId}{Output variable name.}
}
\description{
UI-side functions for creating dynamic \code{lcarBox()} and \code{lcarsSweep()}.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

  ui <- lcarsPage(
    lcarsBoxOutput("box"),
    lcarsSweepOutput("sweep")
  )

  server <- function(input, output) {
    output$box <- renderLcarsBox({
      lcarsBox()
    })
    output$sweep <- renderLcarsSweep({
      lcarsSweep()
    })
  }

  shinyApp(ui, server)
}
}
\seealso{
\code{\link[=renderLcars]{renderLcars()}} for the corresponding server-side
function.
}
