% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_lcsm_lavaan_syntax.R
\name{specify_uni_lcsm}
\alias{specify_uni_lcsm}
\title{Specify lavaan model for univariate latent change score models}
\usage{
specify_uni_lcsm(timepoints, var, model, add = NULL, change_letter = "g")
}
\arguments{
\item{timepoints}{Number if timepoints.}

\item{var}{String, specifying letter to be used for of variables (Usually x or y).}

\item{model}{List of model specifications (logical) for the variables specified in \code{variable}.
\itemize{
\item{\code{alpha_constant}: Constant change factor},
\item{\code{alpha_piecewise}: Piecewise constant change factors},
\item{\code{alpha_piecewise_num}: Changepoint of piecewise constant change factors},
\item{\code{alpha_linear}: Linear change factor},
\item{\code{beta}: Proportional change factor},
\item{\code{phi}: Autoregression of change scores}.
}}

\item{add}{String, lavaan syntax to be added to the model}

\item{change_letter}{String, specifying letter to be used for change factor (Usually g or j).}
}
\value{
Lavaan model syntax including comments.
}
\description{
Specify lavaan model for univariate latent change score models
}
\examples{
# Specify univariate LCSM
lavaan_uni_lcsm_01 <- specify_uni_lcsm(timepoints = 10, 
                                       model = list(alpha_constant = TRUE, 
                                                    beta = TRUE, 
                                                    phi = TRUE), 
                                       var = "x",  
                                       change_letter = "g")
                 
#' # To look at string simply return the object                                    
lavaan_uni_lcsm_01

# To get a readable output use cat() function
cat(lavaan_uni_lcsm_01)

}
\references{
Ghisletta, P., & McArdle, J. J. (2012). Latent Curve Models and Latent Change Score Models Estimated in R. Structural Equation Modeling: A Multidisciplinary Journal, 19(4), 651–682. \doi{10.1080/10705511.2012.713275}.

Grimm, K. J., Ram, N., & Estabrook, R. (2017). Growth Modeling—Structural Equation and Multilevel Modeling Approaches. New York: The Guilford Press.

McArdle, J. J. (2009). Latent variable modeling of differences and changes with longitudinal data. Annual Review of Psychology, 60(1), 577–605. \doi{10.1146/annurev.psych.60.110707.163612}.

Yves Rosseel (2012). lavaan: An R Package for Structural Equation Modeling. Journal of Statistical Software, 48(2), 1-36.
\doi{10.18637/jss.v048.i02}.
}
