% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dihedral.R
\name{dihedral}
\alias{dihedral}
\title{Calculate the dihedral angle between two planes}
\usage{
dihedral(plane1, plane2, Ahmes = FALSE, ID = NULL, pitch1, roll1, course1,
  pitch2, roll2, course2, horiz = TRUE)
}
\arguments{
\item{plane1, plane2}{Objects of class data.frame containing the angles of plane1 and plane2 and row labels.}

\item{Ahmes}{Logical. Do data come from 'Ahmes'? Defaults to FALSE}

\item{ID}{An optional vector with the labels of the observations. Defaults to \code{NULL}.}

\item{pitch1, pitch2}{Numeric. The name of the variables containing the pitch angles of planes 1 and 2 in degrees. See details.}

\item{roll1, roll2}{Numeric. The name of the variables containing the roll angles of planes 1 and 2 in degrees. See details.}

\item{course1, course2}{Numeric. The name of the variables containing the course angles of planes 1 and 2 in degrees. See details.}

\item{horiz}{Logical. Set the position of the start (zero, 0) of pitch, roll and tilt angle data. \code{horiz = F} indicates the zero is located at zenith. This is the reference system used by Ahmes. \code{horiz = T} indicates the start is at the horizon. To use tilt in further calculations (\code{\link{star}}, \code{\link{sal}}...), angle data should be expressed in the horizontal reference system (0 = horizon). Defaults to \code{TRUE}.}
}
\description{
Calculate the minimum angle between two non-orthogonal planes, such as the angle describing leaf torsion, the angle between two halves of conduplicate or plicate leaves, the angle between the petiole and the branch, between two leaves and between two branches.
}
\details{
\code{pitch} values span from 0 to 180 degrees. If \code{horiz = TRUE} (default) 0 and 180 refer to the flat horizontal surface and 90 refers to the flat vertical surface. If \code{horiz = FALSE} 0 and 180 refer to the flat vertical surface and 90 refers to the flat horizontal surface.

\code{roll} values span from 0 to 180 degrees.

\code{course} values span from 0 (North) to 360 degrees, clockwise. Course is the angle between north and the horizontal projection of a normal vector to the surface.

For a graphical explanation of leaf angles, see Fig. 2 in  Escribano-Rocafort et al. (2014).
}
\examples{
\donttest{data(orchids)
  pseudobulbs<-subset(orchids,organ=="pseudobulb") #subset
  leaves<-subset(orchids,organ=="leaf")
  dihedral(plane1=pseudobulbs,plane2=leaves,Ahmes=FALSE,ID=NULL,pitch1=pseudobulbs$pitch,
  roll1=pseudobulbs$roll,course1=pseudobulbs$course,pitch2=leaves$pitch,roll2=leaves$roll,
  course2=leaves$course,horiz=FALSE)}  
#dihedral()
}
\references{
\code{dihedral} \strong{Santalo, L.A. (1970).} Vectores y tensores con sus aplicaciones. p. 61, 8 Edicion. EUDEBA (eds), Buenos Aires, Argentina.

\strong{Escribano-Rocafort, A.G., Ventre-Lespiaucq, A.B., Granado-Yela, C., Lopez-Pintor, A., Delgado, J.A., Munoz, V., Dorado, G.A., Balaguer, L. (2014).} Simplifying data acquisition in plant canopies- Measurements of leaf angles with a cell phone. Methods in Ecology and Evolution 5:132-140. doi:10.1111/2041-210X.12141.

\code{orchids} \strong{Ventre-Lespiaucq, A.B., Delgado, J.A., Ospina-Calderon, N.H., Otero, J.T., Escudero, A., Sanchez, M.A., Balaguer, L., Flanagan, N.S. (2017).} A tropical epiphytic orchid uses a low-light interception strategy in a spatially heterogeneous light environment. Biotropica, 49:318-327. doi:10.1111/btp.12425.
}
\author{
Agustina Ventre-Lespiaucq and Silvia Santamaria Bueno.
}
