% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tilt.R
\name{tilt}
\alias{tilt}
\title{Calculate the tilt angle}
\usage{
tilt(x, Ahmes = F, ID = NULL, pitch, roll, horiz = T)
}
\arguments{
\item{x}{A dataframe with observations in the rows and at least two spatial position angles in the columns. Data can come either from 'Ahmes' 1.0 or from measurements performed with traditional instrumentation.}

\item{Ahmes}{Logical. Do data come from 'Ahmes'? Defaults to FALSE.}

\item{ID}{An optional vector with the labels of the observations. Defaults to \code{NULL}.}

\item{pitch}{A vector with pitch angles in degrees. See details.}

\item{roll}{A vector with roll angles in degrees. See details.}

\item{horiz}{Logical. Set the position of the start (zero, 0) of pitch, roll and tilt angle data. \code{horiz = F} indicates the zero is located at zenith. This is the reference system used by 'Ahmes'. \code{horiz = T} indicates the start is at the horizon. To use tilt in further calculations (\code{\link{star}}, \code{\link{sal}}...), angle data should be expressed in the horizontal reference system (0 = horizon). Defaults to \code{TRUE}.}
}
\description{
Calculate the tilt angle of a tilted surface from pitch and roll angles.
}
\details{
The output of \code{tilt()} is a matrix with two columns "tilt.raw" and "tilt". "tilt.raw" contains tilt values relative to the zenith. "tilt" contains tilt values relative to the horizon. The latter are used in the equations of the \code{star()} family. When \code{horiz = T}, "tilt" = "tilt.raw".

\code{pitch} values span from 0 to 180 degrees. If \code{horiz = TRUE} (default) 0 and 180 refer to the flat horizontal surface and 90 refers to the flat vertical surface. If \code{horiz = FALSE} 180 refers to the flat vertical surface and 90 refers to the flat horizontal surface.

\code{roll} values span from 0 to 180 degrees.

For a graphical explanation, see Fig. 2 in Escribano-Rocafort et al. (2014).
}
\examples{
\donttest{# Data comes from 'Ahmes'
data(olea)
    tilt_olea<-tilt(olea,Ahmes=TRUE)

 # Data comes from other sources
   data(tropical)
    tropi_tilt<-tilt(tropical,pitch=tropical$pitch,roll=tropical$roll,horiz=TRUE)
    tropical2<-cbind(tropical,as.data.frame(tropi_tilt)) 
    # When horiz = TRUE, tilt.raw = tilt!

   data(guava)
    tilt_guava<-tilt(guava,pitch=guava$pitch,roll=guava$roll,horiz=FALSE) 
    # horiz = FALSE}

#tilt()
}
\references{
\strong{Escribano-Rocafort, A.G., Ventre-Lespiaucq, A.B., Granado-Yela, C., Lopez-Pintor, A., Delgado, J.A., Munoz, V., Dorado, G.A., Balaguer, L. (2014).} Simplifying data acquisition in plant canopies- Measurements of leaf angles with a cell phone. Methods in Ecology and Evolution 5:132-140. doi:10.1111/2041-210X.12141.

\code{tropical} \strong{Posada, J.M., Lechowicz, M.J., Kitajima, K. (2009).} Optimal photosynthetic use of light by tropical tree crowns achieved by adjustment of individual leaf angles and nitrogen content. Annals of Botany, 103: 795-805. doi:10.1093/aob/mcn265.
}
\author{
Agustina Ventre-Lespiaucq and Silvia Santamaria Bueno.
}
\keyword{'Ahmes'}
