% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterCharts.R
\name{addClusterCharts}
\alias{addClusterCharts}
\title{addClusterCharts}
\usage{
addClusterCharts(
  map,
  layerId = NULL,
  group = NULL,
  type = c("pie", "bar", "horizontal", "custom"),
  aggregation = c("sum", "min", "max", "mean", "median"),
  valueField = NULL,
  options = clusterchartOptions(),
  icon = NULL,
  html = NULL,
  popup = NULL,
  popupOptions = NULL,
  label = NULL,
  labelOptions = NULL,
  clusterOptions = NULL,
  clusterId = NULL,
  categoryField,
  categoryMap,
  popupFields = NULL,
  popupLabels = NULL,
  markerOptions = NULL,
  legendOptions = list(title = "", position = "topright"),
  data = getMapData(map)
)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{type}{The type of chart to use for clusters: \code{"pie"}, \code{"bar"}, \code{"horizontal"}, or \code{"custom"}.}

\item{aggregation}{Aggregation method for \code{"custom"} charts (e.g., sum, min, max, mean, median).}

\item{valueField}{Column name with values to aggregate for \code{"custom"} charts.}

\item{options}{Additional options for cluster charts (see \code{\link{clusterchartOptions}}).}

\item{icon}{An icon or set of icons to include, created with \code{makeIcon} or \code{iconList}.}

\item{html}{The column name containing the HTML content to include in the markers.}

\item{popup}{The column name used to retrieve feature properties for the popup.}

\item{popupOptions}{A Vector of \code{\link[leaflet]{popupOptions}} to provide popups}

\item{label}{a character vector of the HTML content for the labels}

\item{labelOptions}{A Vector of \code{\link[leaflet]{labelOptions}} to provide label
options for each label. Default \code{NULL}}

\item{clusterOptions}{if not \code{NULL}, markers will be clustered using
\href{https://github.com/Leaflet/Leaflet.markercluster}{Leaflet.markercluster};
 you can use \code{\link[leaflet]{markerClusterOptions}()} to specify marker cluster
options}

\item{clusterId}{the id for the marker cluster layer}

\item{categoryField}{Column name for categorizing charts.}

\item{categoryMap}{A data.frame mapping categories to chart properties (e.g., label, color, icons, stroke).}

\item{popupFields}{A string or vector of strings indicating the column names to include in popups.}

\item{popupLabels}{A string or vector of strings indicating the labels for the popup fields.}

\item{markerOptions}{Additional options for markers (see \code{\link[leaflet:markerOptions]{markerOptions::markerOptions()}}).}

\item{legendOptions}{A list of options for the legend, including the title and position.}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}
}
\description{
Clusters markers on a Leaflet map and visualizes them using
customizable charts, such as pie or bar charts, showing counts by category.
When using the \code{"custom"} type, a pie chart is rendered with aggregated data,
employing methods like sum, min, max, mean, or median.
}
\details{
The `clusterCharts` use Leaflet's `L.DivIcon`, allowing you to fully customize
the styling of individual markers and clusters using CSS. Each individual marker
within a cluster is assigned the CSS class `clustermarker`, while the entire
cluster is assigned the class `clustermarker-cluster`. You can modify the appearance
of these elements by targeting these classes in your custom CSS.
}
\examples{
# Example usage:
library(sf)
library(leaflet)
library(leaflet.extras2)

data <- sf::st_as_sf(breweries91)
categories <- c("Schwer", "Mäßig", "Leicht", "kein Schaden")
data$category <- sample(categories, size = nrow(data), replace = TRUE)

## Pie Chart
leaflet() \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  leaflet::addLayersControl(overlayGroups = "clustermarkers") \%>\%
  addClusterCharts(
    data = data,
    categoryField = "category",
    categoryMap = data.frame(
      labels = categories,
      colors = c("#F88", "#FA0", "#FF3", "#BFB"),
      strokes = "gray"
    ),
    group = "clustermarkers",
    popupFields = c("brewery", "address", "zipcode", "category"),
    popupLabels = c("Brauerei", "Adresse", "PLZ", "Art"),
    label = "brewery"
  )

## Bar Chart
leaflet() \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  leaflet::addLayersControl(overlayGroups = "clustermarkers") \%>\%
  addClusterCharts(
    data = data,
    type = "bar",
    categoryField = "category",
    categoryMap = data.frame(
      labels = categories,
      colors = c("#F88", "#FA0", "#FF3", "#BFB"),
      strokes = "gray"
    ),
    group = "clustermarkers",
    popupFields = c("brewery", "address", "zipcode", "category"),
    popupLabels = c("Brauerei", "Adresse", "PLZ", "Art"),
    label = "brewery"
  )

## Custom Pie Chart with "mean" aggregation on column "value"
data <- sf::st_as_sf(breweries91)
categories <- c("Schwer", "Mäßig", "Leicht", "kein Schaden")
data$category <- sample(categories, size = nrow(data), replace = TRUE)
data$value <- round(runif(nrow(data), 0, 100), 0)

leaflet() \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  leaflet::addLayersControl(overlayGroups = "clustermarkers") \%>\%
  addClusterCharts(
    data = data,
    type = "custom",
    valueField = "value",
    aggregation = "mean",
    categoryField = "category",
    categoryMap = data.frame(
      labels = categories,
      colors = c("#F88", "#FA0", "#FF3", "#BFB"),
      strokes = "gray"
    ),
    options = clusterchartOptions(rmax = 50, digits = 0, innerRadius = 20),
    group = "clustermarkers",
    popupFields = c("brewery", "address", "zipcode", "category", "value"),
    popupLabels = c("Brauerei", "Adresse", "PLZ", "Art", "Value"),
    label = "brewery"
  )

## For Shiny examples, please run:
# runApp(system.file("examples/clusterCharts_app.R", package = "leaflet.extras2"))
# runApp(system.file("examples/clustercharts_sum.R", package = "leaflet.extras2"))
}
\seealso{
Other clusterCharts: 
\code{\link{clusterchartOptions}()}
}
\concept{clusterCharts}
