% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/letter_value.R
\name{letter_value}
\alias{letter_value}
\title{Compute Letter Value.}
\usage{
letter_value(x, level = 2, na_rm = TRUE)
}
\arguments{
\item{x}{numeric vector}

\item{level}{integer value between 2 and 9 indicating the level to compute the letter values. Default value is 2.}

\item{na_rm}{a logical evaluating to \code{TRUE} or \code{FALSE} indicating whether NA values should be stripped before the computation proceeds. Default value is \code{TRUE}.}
}
\value{
a \code{list} object is returned with the variable name (\code{variable_name}), the sample (\code{sample}), and a data frame with the following columns:
\describe{
 \item{letter}{a letter indicating the letter value}
 \item{depth}{depth of the letter value}
 \item{lv_lower}{lower letter value}
 \item{lv_upper}{upper letter value}
}
}
\description{
\code{letter_value} returns the letter values until the level indicated by \code{level}.
}
\details{
This function computes the letter values as presented at Understanding Robust and Exploratory Data Analysis by Hoaglin, Mosteller and Tukey published in 1983.
}
\examples{
letter_value(rivers)
}
