% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth_selection.R
\name{bw_select}
\alias{bw_select}
\title{Bandwidth selection for local Gaussian correlation.}
\usage{
bw_select(x, bw_method = "plugin", est_method = "1par",
  plugin_constant_marginal = 1.75, plugin_exponent_marginal = -1/5,
  plugin_constant_joint = 1.75, plugin_exponent_joint = -1/6,
  tol_marginal = 10^(-3), tol_joint = 10^(-3))
}
\arguments{
\item{x}{A matrix or data frame with data, one column per variable, one row
per observation.}

\item{bw_method}{The method used for bandwidth selection. Must be either
\code{"cv"} (cross-validation, slow, but accurate) or \code{"plugin"}
(fast, but crude).}

\item{est_method}{The estimation method, must be either "1par", "5par" or
"5par_marginals_fixed", see \code{\link{lg_main}}.}

\item{plugin_constant_marginal}{The constant \code{c} in \code{cn^a} used for
finding the plugin bandwidth for locally Gaussian marginal density
estimates, which we need if estimation method is "5par_marginals_fixed".}

\item{plugin_exponent_marginal}{The constant \code{a} in \code{cn^a} used for
finding the plugin bandwidth for locally Gaussian marginal density
estimates, which we need if estimation method is "5par_marginals_fixed".}

\item{plugin_constant_joint}{The constant \code{c} in \code{cn^a} used for
finding the plugin bandwidth for estimating the pairwise local Gaussian
correlation between two variables.}

\item{plugin_exponent_joint}{The constant \code{a} in \code{cn^a} used for
finding the plugin bandwidth for estimating the pairwise local Gaussian
correlation between two variables.}

\item{tol_marginal}{The absolute tolerance in the optimization for finding
the marginal bandwidths when using cross validation.}

\item{tol_joint}{The absolute tolerance in the optimization for finding the
joint bandwidths when using cross-validation.}
}
\value{
A list with three elements, \code{marginal}  contains the bandwidths
  used for the marginal locally Gaussian estimation,
  \code{marginal_convergence} contains the convergence flags for the marginal
  bandwidths, as returned by the \code{optim} function, and \code{joint}
  contains the pairwise bandwidths and convergence flags.
}
\description{
Takes a matrix of data points and returns the bandwidths used for estimating
the local Gaussian correlations.
}
\details{
This is the main bandwidth selection function within the framework of locally
Gaussian distributions as described in Otneim and Tjøstheim (2017). This
function takes in a data set of arbitrary dimension, and calculates the
bandwidths needed to find the pairwise local Gaussian correlations, and
is mainly used by the main \code{lg_main} wrapper function.
}
\examples{
  x <- cbind(rnorm(100), rnorm(100), rnorm(100))
  bw <- bw_select(x)

}
\references{
Otneim, Håkon, and Dag Tjøstheim. "The locally gaussian density estimator for
multivariate data." Statistics and Computing 27, no. 6 (2017): 1595-1616.
}
