% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharedFunction.R
\name{lglasso}
\alias{lglasso}
\title{Graphical Lasso for Longitudinal Data}
\usage{
lglasso(
  data,
  rho,
  heter = TRUE,
  type = 1,
  tole = 0.01,
  lower = 0.01,
  upper = 10
)
}
\arguments{
\item{data}{Data matrix  in which the first column is subject id, the second column is
time points of observations for temporal data or site id for spatial data.  Columns \code{3} to \code{(p+2)} is the observations for \code{p} variables.}

\item{rho}{Tuning parameter used in \code{L_1} penalty}

\item{heter}{Binary variable \code{TRUE} or \code{FALSE}, indicating heterogeneous model or homogeneous model is fitted. In heterogeneous model,
subjects are allowed to have his/her own temporal correlation parameter \code{tau_i}; while in homogeneous model, all the subjects are assumed to
 share the same temporal correlation parameter,i.e., \code{tau_1=tau_2=...tau_m}.}

\item{type}{A positive number which specify the correlation function. The general form of correlation function  is given by \code{ exp(tau|t_i-t_j|^type)}.
in which \code{type=0} can be used for spatial correlation while \code{type>0} are used for temporal correlation. For latter, the default value is set to be \code{type=1}.}

\item{tole}{Threshold for convergence. Default value is \code{1e-2}. Iterations stop when maximum
absolute difference between consecutive estimates of parameter change is less than \code{tole}.}

\item{lower}{Lower bound for predicts of correlation parameter \code{tau}.
Default value is \code{1e-2}. The estimate of \code{tau}(\code{alpha}) will be searched in the
interval \code{[lower,upper]}, where parameter \code{upper} is explained in the following.}

\item{upper}{Upper bound for predicts of correlation parameter \code{tau}.}
}
\value{
If \code{heter=TRUE}, then a list with three components is returned which are  respectively
the estimate of parameter \code{alpha} in exponent distribution, correlation parameter \code{tau} and precision matrix \code{omega}. If \code{heter=FALSE},
then a list with two components is returned which are respectively the estimate of correlation parameter \code{tau} and precision matrix \code{omega}.
}
\description{
This function implements the L_1 penalized maximum likelihood estimation for precision matrix (network)  based on correlated data, e.g., irregularly spaced longitudinal
 data. It can be regarded as an extension of the package \code{glasso} (Friedman,Hastie and Tibshirani, 2008) which aims
 to find the sparse estimate of the network from independent continuous data.
}
\examples{
sample_data[1:5,1:5]
dim(sample_data)
## Heterogeneous model with dampening correlation rate using the first three clusters
a=lglasso(data = sample_data[1:11,], rho = 0.7,heter=TRUE, type=1)
### Estimates of correlation parameters
a$tau
### Sub-network for the first five variables
a$omega[1:5,1:5]
### Total number of the edges in the estimated network
(length(which(a$omega!=0))-ncol(a$omega))/2
## Homogeneous model with dampening correlation rate using the first three clusters
b=lglasso(data = sample_data[1:11,], rho = 0.7,heter=FALSE,type=1)
### Estimates of correlation parameters
b$tau
### Sub-network for the first five  variables
b$omega[1:5,1:5]
### Total number of the edges in the estimated network
(length(which(b$omega!=0))-ncol(b$omega))/2
## Heterogeneous model with uniform correlation rate using the first three clusters
c=lglasso(data = sample_data[1:11,], rho = 0.7,heter=TRUE,type=0)
### Estimates of correlation parameters
c$tau
### Sub-network for the first five  variables
c$omega[1:5,1:5]
### Total number of the edges in the estimated network
(length(which(c$omega!=0))-ncol(c$omega))/2
## Homogeneous model with uniform correlation rate using the first three clusters
d=lglasso(data = sample_data[1:11,], rho = 0.7,heter=FALSE,type=0)
### Estimates of correlation parameters
d$tau
### Sub-network for the first five  variables
d$omega[1:5,1:5]
### Total number of the edges in the estimated network
(length(which(d$omega!=0))-ncol(d$omega))/2
}
\references{
Jie Zhou, Jiang Gui, Weston D.Viles, Anne G.Hoen Identifying Microbial Interaction Networks Based on Irregularly Spaced Longitudinal 16S rRNA sequence data. bioRxiv 2021.11.26.470159; doi: https://doi.org/10.1101/2021.11.26.470159

Friedman J, Tibshirani TH and R. Glasso: Graphical Lasso: Estimation of Gaussian Graphical Models.; 2019. Accessed November 28, 2021. https://CRAN.R-project.org/package=glasso

Friedman J, Hastie T, Tibshirani TH, Sparse inverse covariance estimation with the graphical lasso, Biostatistics, Volume 9, Issue 3, July 2008, Pages 432–441, https://doi.org/10.1093/biostatistics/kxm045
}
\author{
Jie Zhou
}
