% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_levels.R
\name{label_levels}
\alias{label_levels}
\alias{unlabel_levels}
\title{Label/Unlabel Log Levels}
\usage{
label_levels(levels, log_levels = getOption("lgr.log_levels"))

unlabel_levels(labels, log_levels = getOption("lgr.log_levels"))
}
\arguments{
\item{levels}{an \code{integer} vector of log levels}

\item{log_levels}{named \code{integer} vector of valid log levels}

\item{labels}{a \code{character} vector of log level labels. Please note that
log levels are lowercase by default, even if many appenders print them
in uppercase.}
}
\value{
a \code{character} vector for \code{label_levels()} and an integer vector for
\code{unlabel_levels}
}
\description{
Label/Unlabel Log Levels
}
\examples{
x <- label_levels(c(seq(0, 600, by = 100), NA))
print(x)
unlabel_levels(x)
}
\seealso{
\code{\link[=get_log_levels]{get_log_levels()}}

Other formatting utils: 
\code{\link{colorize_levels}()}
}
\concept{formatting utils}
