% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_loglik.R
\name{prior_loglik}
\alias{prior_loglik}
\title{Log-Prior Distribution Evaluation for lgspline Models}
\usage{
prior_loglik(model_fit, sigmasq = NULL)
}
\arguments{
\item{model_fit}{An lgspline model object}

\item{sigmasq}{A scalar numeric representing the dispersion parameter. By default it is NULL, and the sigmasq_tilde associated with model_fit will be used. Otherwise, custom values can be supplied.}
}
\value{
A numeric scalar for the prior-loglikelihood (the penalty on beta coefficients
actually computed)
}
\description{
Evaluates the log-prior distribution on beta coefficients conditional upon dispersion and penalaties,
}
\details{
Returns the quadratic form of B^T(Lambda)B evaluated at the
tuned or fixed penalties, scaled by negative one-half inverse dispersion.


Assuming fixed penalties, the prior distribution of \eqn{\beta} is given as follows:

\deqn{\beta | \sigma^2 \sim \mathcal{N}(\textbf{0}, \frac{1}{\sigma^2}\Lambda)}

The log-likelihood obtained from this can be shown to be equivalent to the following,
with \eqn{C} a constant with respect to \eqn{\beta}.

\deqn{\implies \log P(\beta|\sigma^2) = C-\frac{1}{2\sigma^2}\beta^{T}\Lambda\beta}

This is useful for computing joint log-likelihoods and performing valid
likelihood ratio tests between nested lgspline models.
}
\examples{
## Data
t <- sort(runif(100, -5, 5))
y <- sin(t) - 0.1*t^2 + rnorm(100)

## Model keeping penalties fixed
model_fit <- lgspline(t, y, opt = FALSE)

## Full joint log-likelihood, conditional upon known sigma^2 = 1
jntloglik <- sum(dnorm(model_fit$y,
                    model_fit$ytilde,
                    1,
                    log = TRUE)) +
          prior_loglik(model_fit, sigmasq = 1)
print(jntloglik)

}
\seealso{
\code{\link{lgspline}}
}
