% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_tbl_to_file.R
\name{combine_tbl_to_file}
\alias{combine_tbl_to_file}
\title{Combine a parsed tbl Rmd / Qmd file into a new file}
\usage{
combine_tbl_to_file(parsed_tbl, output_file)
}
\arguments{
\item{parsed_tbl}{A tibble with columns as issued by \code{split_to_tbl()}}

\item{output_file}{A Rmd / Qmd file path to write the new content}
}
\value{
The content of a Rmd / Qmd file as character and
the resulting file if output_file is provided.
}
\description{
Combine a parsed tbl Rmd / Qmd file into a new file
}
\examples{
file <- system.file("dev-template-parsing.Rmd",
  package = "lightparser"
)
# split first
tbl_rmd <- split_to_tbl(file)
# apply your filters
tbl_rmd_filtered <- tbl_rmd[-5, ]
# combine then
combine_tbl_to_file(tbl_rmd_filtered, tempfile(fileext = ".Rmd"))
}
