% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_qqplot.R
\name{gg_qqplot}
\alias{gg_qqplot}
\title{Plot quantile-quantile plot (QQPlot) in ggplot with qqline shown.}
\usage{
gg_qqplot(fitted.lm, scale.factor = 1)
}
\arguments{
\item{fitted.lm}{a fitted linear model (i.e. lm, glm) that contains fitted regression}

\item{scale.factor}{numeric; scales the point size and linewidth to allow customized viewing. Defaults to 1.}
}
\value{
A qqplot with fitted qqline
}
\description{
Plot quantile-quantile plot (QQPlot) in ggplot with qqline shown.
}
\examples{
library(MASS)
data(Cars93)
cars_lm <- lm(Price ~ Passengers + Length + RPM, data = Cars93)
gg_qqplot(cars_lm)
}
