% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_scalelocation.R
\name{gg_scalelocation}
\alias{gg_scalelocation}
\title{Plot scale-location (also called spread-location plot) in ggplot.}
\usage{
gg_scalelocation(fitted.lm, method = "loess", scale.factor = 1, se = FALSE)
}
\arguments{
\item{fitted.lm}{a fitted linear model (i.e. lm, glm) that contains fitted regression}

\item{method}{smoothing method of fitted line on scale-location plot.
eg. "lm", "glm", "gam", "loess", "rlm". See \url{https://ggplot2.tidyverse.org/reference/geom_smooth.html}
for more details.}

\item{scale.factor}{numeric; scales the point size and linewidth to allow customized viewing. Defaults to 1.}

\item{se}{logical; determines whether se belt should be plotted on plot}
}
\value{
A ggplot object that contains scale-location graph
}
\description{
Plot scale-location (also called spread-location plot) in ggplot.
}
\examples{
library(MASS)
data(Cars93)
cars_lm <- lm(Price ~ Passengers + Length + RPM, data = Cars93)
gg_scalelocation(cars_lm)
}
