% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterVariables.R
\name{clusterVariables}
\alias{clusterVariables}
\title{Variable clustering (using Normal Mixture Modeling for Model-Based Clustering : mclust)}
\usage{
clusterVariables(corMatrix, nbCluster = 1:9)
}
\arguments{
\item{corMatrix}{a dataframe corresponding to a correlation matrix}

\item{nbCluster}{an integer or a vector of integers corresponding to the preferred number of cluster for the unsupervised learning.}
}
\value{
a dataframe: the first column contains the variable names, the second column the index of the cluster they are affected to.
}
\description{
Computation of a variable clustering on a correlation matrix.
}
\examples{
# calculate a correlation dataframe
data(iris)
corDF <- multiBivariateCorrelation(dataset = iris, corMethods = "MaxNMI")
# tranform to correlation matrix
corMatrix <- corCouplesToMatrix(x1_x2_val = corDF[,c('X1','X2',"MaxNMI")])
# perform the clustering
corGroups <- clusterVariables(corMatrix = corMatrix, nbCluster = 3)
print(corGroups)

}
