% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_sort.R
\name{list_sort}
\alias{list_sort}
\title{Sort a list.}
\usage{
list_sort(in_list, sort_fun, descending = FALSE, use_na = "drop")
}
\arguments{
\item{in_list}{The list to work on.}

\item{sort_fun}{The function to sort the list by.}

\item{descending}{Boolean, if TRUE items will be sorted in descending order.}

\item{use_na}{String, one of `drop`, `first` or `last`.}
}
\value{
A list, `in_list` sorted according to `sort_fun`.
}
\description{
Sort a list.
}
\details{
The list will be sorted according to the return value of `sort_fun`. The
function must return a numeric value that will then be used to order the
list items.

If the function returns `NA` the sorting will depend on the string
specified to `use_missing`. The default is to drop these values, but they can
optionally be put first or last in the sorted list.

If the sorting function returns `NA` for some items and `use_na` is `first`
or `last` then the order of the `NA` items will most likely be the same
as in `in_list` (but this cannot be guaranteed). The same is true for
ties.
}
\examples{
my_list <- list(data.frame(x = 1:10),
                data.frame(x = 1:5, y = rnorm(5)),
                data.frame(x = 1:20, y = rnorm(20), z = LETTERS[1:20]))
list_sort(my_list, nrow)
list_sort(my_list, function(x) sum(x$x), descending = TRUE)
}
