% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.lpca.R
\name{bootstrap.lpca}
\alias{bootstrap.lpca}
\title{Bootstrap procedure for Logistic (Restricted) PCA}
\usage{
bootstrap.lpca(object, Bsamples = 1000, myseed = 1)
}
\arguments{
\item{object}{An output object from lpca}

\item{Bsamples}{Number of Bootstrap samples to take}

\item{myseed}{A seed number to make the bootstrap reproducible}
}
\value{
BBdf Bootstrap estimates of B

BVdf Bootstrap estimates of V
}
\description{
Bootstrap procedure for Logistic (Restricted) PCA
}
\examples{
\dontrun{
data(dataExample_lpca)
Y = as.matrix(dataExample_lpca[, 1:8])
X = as.matrix(dataExample_lpca[, 9:13])
# supervised
output = lpca(Y = Y, X = X, S = 2)
boot.output = bootstrap.lpca(output, Bsamples = 100)
plot(boot.output)
}

}
