% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locStra.r
\name{bed_fastCovEVs}
\alias{bed_fastCovEVs}
\title{Computation of the k leading eigenvectors of the covariance matrix directly from a bed+bim+fam file.}
\usage{
bed_fastCovEVs(f, k, q = 2)
}
\arguments{
\item{f}{The filename of the bed file (including its extension). The bim and fam files need to be in the same folder and have the same base filename.}

\item{k}{The number of leading eigenvectors.}

\item{q}{The number of power iteration steps (default is \code{q=2}).}
}
\value{
The k leading eigenvectors of the covariance matrix of \code{m} as a column matrix.
}
\description{
Computation of the k leading eigenvectors of the covariance matrix directly from a bed+bim+fam file.
}
\examples{
require(locStra)

}
\references{
R Core Team (2014). R: A Language and Environment for Statistical Computing. R Foundation for Stat Comp, Vienna, Austria.

N. Halko, P.G. Martinsson, and J.A. Tropp (2011). Finding Structure with Randomness: Probabilistic Algorithms for Constructing Approximate Matrix Decompositions. SIAM Review: 53(2), pp. 217--288.

F. Prive, M. Blum, H. Aschard, B.J. Vilhjalmsson (2022). bigsnpr: Analysis of Massive SNP Arrays. https://cran.r-project.org/package=bigsnpr
}
