% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omniSpectro.R
\name{omniSpectro}
\alias{omniSpectro}
\title{Generate grid of spectrograms for detecting sounds of interest.}
\usage{
omniSpectro(st, lm, intervalLength = 5, intervals = "all")
}
\arguments{
\item{st}{List. Localization settings object generated using
\code{\link{processSettings}}.}

\item{lm}{layout matrix generated using the `layoutMatrix()` function, or a
user-generated matrix in the same format. This matrix controls how the spectrograms
from each station are mapped to rows and columns.}

\item{intervalLength}{Integer The length of each view interval to be generated, in seconds.
Consecutive windows overlap, by default by 1 second. Setting intervalLength = 5 will therefore
create 6-second spectrogram views, with one second overlap (e.g.
0 to 6, then 5 to 11, 10 to 16, etc.).}

\item{intervals}{Integer or 'all'. Which intervals to write to jpeg. For testing
purposes, it is often desirable to set this to, e.g. intervals = 1:5, which
will create only the first five view windows, to ensure the function is working.}
}
\value{
No return value.
}
\description{
\code{omniSpectro} creates a grid of time-synchronized spectrograms, to
facilitate the manual detection of birds across a microphone array. By opening
the resulting jpeg images in an image viewing program (e.g. the standard Microsoft Photos app),
short clips of sounds can be viewed across an entire microphone array at once.
The authors of this package have found this to be an efficient way to view spectrograms,
while effectively eliminating the likelihood of double-counting sound sources that
may be clearly detectable on many microphones at the same time. At the present time,
this function only works when a settings object, st, is provided.
}
\examples{
    \donttest{
    #First need to convert mp3 example data to wav.
    #list mp3 files.
    f.in <- list.files(system.file('extdata', package = 'locaR'), full.names = TRUE, pattern='mp3$')
    #create wav names.
    f.out <- file.path(tempdir(), basename(f.in))
    #change extension.
    substr(f.out, nchar(f.out)-2, nchar(f.out)) <- 'wav'
    #Convert mp3 to wav, as required for this particular example.
    for(i in 1:length(f.in)) {
      y <- tuneR::readMP3(f.in[i])
      tuneR::writeWave(y, filename = f.out[i])
    }
    #Set up survey.
    survey <- setupSurvey(folder = tempdir(), projectName = 'Ex', run = 1,
               coordinatesFile = system.file('extdata', 'Vignette_Coordinates.csv',
                                             package = 'locaR'),
               siteWavsFolder = tempdir(), date = '20200617', time = '090000', surveyLength = 7)
    #Process settings.
    st <- processSettings(settings = survey, getFilepaths = TRUE, types = 'wav')
    #Set up layout matrix.
    lm <- layoutMatrix(st = st, start = 'topleft', byrow = TRUE, nrow = 3, ncol = 3)
    #create detection spectrograms.
    omniSpectro(st, lm, intervalLength = 7)
    }
}
