% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surveyPaths.R
\name{surveyPaths}
\alias{surveyPaths}
\title{Get paths for standardized survey workflow.}
\usage{
surveyPaths(folder, projectName, date, time, run)
}
\arguments{
\item{folder}{Character. Path to the directory where the survey is to be created.}

\item{projectName}{Character. A string specifying the name of a project.}

\item{date}{Numeric. Eight digit number representing a date in the format
YYYYMMDD.}

\item{time}{Numeric. Five or six digit number representing the start time
of a recording session (90000 = 09:00:00, and 160000 = 16:00:00).}

\item{run}{Numeric. Within each survey, start with run = 1, then count
upwards. So, run 2 would be used to re-localize sounds that were poorly
localized in run 1, etc. Running them again with slightly different
settings (e.g. start/end times or low/high frequencies)
can improve results.}
}
\value{
Named vector of paths to surveyFolder, runFolder, specFolder,
locFolder, detectionsFile, channelsFile, and settingsFile.
}
\description{
Function that takes arguments of a base folder and a project name, date, time,
and run, and returns the appropriate filepaths for a standardized survey
workflow.
}
\examples{
    surveyPaths(folder = tempdir(), projectName = 'Ex', date = '20200617', time = '090000', run = 1)
}
