% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Galtonpar}
\alias{Galtonpar}
\title{Galton family data}
\format{
A data frame with 205 rows of 10 variables:
\describe{
  \item{id}{parent ID, a factor with levels \code{001}-\code{204}}
  \item{father}{height of father}
  \item{mother}{height of mother}
  \item{midparht}{mid-parent height, calculated as \code{(father + 1.08*mother)/2}}
  \item{numchild}{number of children}
  \item{numson}{number of sons}
  \item{numdtr}{number of daughters}
  \item{avgchildht}{average height of children}
  \item{avgsonht}{average height of sons}
  \item{avgdtrht}{average height of daughters}
}
}
\source{
\code{GaltonFamilies} data in \code{HistData} package
}
\usage{
data(Galtonpar)
}
\description{
Parent-level version of Galton's family data
}
\seealso{
\code{HistData::GaltonFamilies}
}
\keyword{datasets}
