% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIA_functions.R
\name{make_grid}
\alias{make_grid}
\title{Make a grid of points}
\usage{
make_grid(n = 40, par, Amax = 2, Bmax = 2, n_reps = 1)
}
\arguments{
\item{n}{number of levels on each side (Total grid is n^2).  Default is 40}

\item{par}{named vector of model parameters}

\item{Amax}{max amount of number of ED50s.  Default is 2}

\item{Bmax}{max amount of number of ED50s.  Default is 2.}

\item{n_reps}{number of replicates to repeat entire grid/experiment.  Default is 1.}
}
\value{
data frame with the following columns
\describe{
\item{dose_A}{unscaled dose of A}
\item{dose_B}{unscaled dose o B}
\item{rep}{replicate number}
}
}
\description{
Make a grid of points
}
\examples{
n <- 40
 par <- c("beta_A" = 1, "beta_B" = 2)
out <- make_grid(n = 2, par = par)
exp_out <- data.frame(dose_A = c(0, 2, 0, 2),
                      dose_B = c(0, 0, 4, 4),
                      rep = 1)
}
