% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logicDT.R
\name{fit4plModel}
\alias{fit4plModel}
\title{Fitting 4pL models}
\usage{
fit4plModel(y, Z)
}
\arguments{
\item{y}{Response vector. 0-1 coding for binary outcomes,
otherwise conventional regression is performed.}

\item{Z}{Numeric vector of (univariate) input samples.}
}
\value{
An object of class \code{"4pl"} which contains a numeric
  vector of the fitted parameters b, c, d, and e.
}
\description{
Method for fitting four parameter logistic models.
In the fashion of this package, only binary and quantitative
outcomes are supported.
}
\details{
4pL models are non-linear regression models of the shape
\deqn{Y = f(x, b, c, d, e) + \varepsilon =
  c + \frac{d-c}{1+\exp(b \cdot (x-e))} + \varepsilon}
with \eqn{\varepsilon} being a random error term.
}
