% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convexLogisticPCA.R
\name{cv.clpca}
\alias{cv.clpca}
\title{CV for convex logistic PCA}
\usage{
cv.clpca(x, ks, ms = seq(2, 10, by = 2), folds = 5, quiet = TRUE, Ms, ...)
}
\arguments{
\item{x}{matrix with all binary entries}

\item{ks}{the different dimensions \code{k} to try}

\item{ms}{the different approximations to the saturated model \code{m} to try}

\item{folds}{if \code{folds} is a scalar, then it is the number of folds. If
it is a vector, it should be the same length as the number of rows in \code{x}}

\item{quiet}{logical; whether the function should display progress}

\item{Ms}{depricated. Use \code{ms} instead}

\item{...}{Additional arguments passed to convexLogisticPCA}
}
\value{
A matrix of the CV negative log likelihood with \code{k} in rows and
 \code{m} in columns
}
\description{
Run cross validation on dimension and \code{m} for convex logistic PCA
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

\dontrun{
negloglikes = cv.clpca(mat, ks = 1:9, ms = 3:6)
plot(negloglikes)
}
}

