% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logisticPCA.R
\name{plot.lpca}
\alias{plot.lpca}
\title{Plot logistic PCA}
\usage{
\method{plot}{lpca}(x, type = c("trace", "loadings", "scores"), ...)
}
\arguments{
\item{x}{logistic PCA object}

\item{type}{the type of plot \code{type = "trace"} plots the algorithms progress by
iteration, \code{type = "loadings"} plots the first 2 principal component
loadings, \code{type = "scores"} plots the loadings first 2 principal component scores}

\item{...}{Additional arguments}
}
\description{
Plots the results of a logistic PCA
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

# run logistic PCA on it
lpca = logisticPCA(mat, k = 2, m = 4, main_effects = FALSE)

\dontrun{
plot(lpca)
}
}

