% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{lol.sims.cross}
\alias{lol.sims.cross}
\title{Cross}
\usage{
lol.sims.cross(n, d, rotate = FALSE, priors = NULL, a = 1, b = 0.25, K = 2)
}
\arguments{
\item{n}{the number of samples of simulated data.}

\item{d}{the dimensionality of the simulated data.}

\item{rotate}{With random rotataion matrix \code{Q}, \code{mu = Q*mu}, and \code{S = Q*S*Q}. Defaults to \code{FALSE}.}

\item{priors}{the priors for each class. If \code{NULL}, class priors are all equal. If not null, should be \code{|priors| = K}, a length \code{K} vector for \code{K} classes. Defaults to \code{NULL}.}

\item{a}{scalar for the magnitude of the variance that is high within the particular class. Defaults to \code{1}.}

\item{b}{scalar for the magnitude of the varaince that is not high within the particular class. Defaults to \code{2}.}

\item{K}{the number of classes. Defaults to \code{2}.}
}
\value{
A list of class \code{simulation} with the following:
\item{X}{\code{[n, d]} the \code{n} data points in \code{d} dimensions as a matrix.}
\item{Y}{\code{[n]} the \code{n} labels as an array.}
\item{mus}{\code{[d, K]} the \code{K} class means in \code{d} dimensions.}
\item{Sigmas}{\code{[d, d, K]} the \code{K} class covariance matrices in \code{d} dimensions.}
\item{priors}{\code{[K]} the priors for each of the \code{K} classes.}
\item{simtype}{The name of the simulation.}
\item{params}{Any extraneous parameters the simulation was created with.}
}
\description{
A simulation for the cross experiment, in which the two classes have orthogonal covariant dimensions and the same means.
}
\section{Details}{

For more details see the help vignette:
\code{vignette("sims", package = "lolR")}
}

\examples{
library(lolR)
data <- lol.sims.cross(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y

}
\author{
Eric Bridgeford
}
