% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cprm.power.R
\name{cprm.power}
\alias{cprm.power}
\title{Chronic progressive repeated measures (CPRM) model sample size calculations.}
\usage{
cprm.power(
  n = NULL,
  delta = NULL,
  power = NULL,
  t = NULL,
  lambda = 1,
  sig2.int = 0,
  sig2.s = NULL,
  sig.b0b1 = 0,
  sig2.e = NULL,
  sig2.int_2 = NULL,
  sig2.s_2 = NULL,
  sig.b0b1_2 = NULL,
  sig2.e_2 = NULL,
  sig.level = 0.05,
  p = NULL,
  p_2 = NULL,
  alternative = c("two.sided", "one.sided"),
  tol = NULL
)
}
\arguments{
\item{n}{sample size, group 1}

\item{delta}{group difference in fixed effect slopes}

\item{power}{power}

\item{t}{the observation times}

\item{lambda}{allocation ratio (sample size group 1 divided by sample size group 2)}

\item{sig2.int}{variance of random intercepts, group 1}

\item{sig2.s}{variance of random slopes, group 1}

\item{sig.b0b1}{covariance of random slopes and intercepts,group 1}

\item{sig2.e}{residual variance, group 1}

\item{sig2.int_2}{variance of random intercepts, group 2 (defaults to \code{sig2.int})}

\item{sig2.s_2}{variance of random slopes, group 2 (defaults to \code{sig2.s})}

\item{sig.b0b1_2}{covariance of random slopes and intercepts, group 2 (defaults to \code{sig.b0b1})}

\item{sig2.e_2}{residual variance, group 2 (defaults to \code{sig2.e})}

\item{sig.level}{type one error}

\item{p}{proportion vector for group 1, if i indexes visits, \code{p[i]} = the proportion whose last visit was at visit \code{i} (\code{p} sums to \code{1})}

\item{p_2}{proportion vector for group 2 (defaults to \code{p})}

\item{alternative}{one- or two-sided test}

\item{tol}{not used (no root finding used in this implementation).}
}
\value{
One of the number of subject required per arm, the \code{power}, or detectable effect size
given \code{sig.level} and the other parameter estimates.
}
\description{
This function performs sample size calculations for the chronic progressive
repeated measures (CPRM) model when used to test for differences of change scores
between groups at last visit. Input parameters are random effect variance
and residual error variance as estimated by a REML fit to representative
pilot data or data from a representative prior clinical trial or cohort
study.
}
\details{
Default settings perform sample size / power / effect size calculations assuming
equal covariance of repeated measures in the 2 groups, equal residual error
variance across groups, equal allocation to groups, and assuming no study subject
attrition.  Specifically, variance parameters required for default settings
are \code{sig2.s}, the variance of random slopes, and \code{sig2.e}, the residual error
variance, both either known or estimated from a mixed model fit by REML
to prior data.

This function accommodates different variance parameters across groups,
unequal allocation across groups, and study subject attrition (loss to followup),
which may also vary across groups. Details can be found in the description of
\code{\link{edland.linear.power}}
}
\examples{

\dontrun{
browseVignettes(package = "longpower")
}
# An Alzheimer's Disease example using ADAS-cog pilot estimates
t <- seq(0,1.5,0.25)
cprm.power(delta=1.5, t=t, sig2.s = 24, sig2.e = 10, sig.level=0.05, power = 0.80)

}
\references{
Zhao Y, Edland SD. The chronic progressive repeated measures (CPRM) model for longitudinal data.
\emph{In process.}
}
\seealso{
\code{\link{lmmpower}}, \code{\link{diggle.linear.power}}, \code{\link{liu.liang.linear.power}}, \code{\link{edland.linear.power}}, \code{\link{hu.mackey.thomas.linear.power}}
}
\author{
Steven D. Edland, Yu Zhao
}
\keyword{effects}
\keyword{mixed}
\keyword{power}
\keyword{random}
\keyword{sample}
\keyword{size}
