% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longurl.r
\name{expand_urls}
\alias{expand_urls}
\title{Expand a vector of (short) URLs using}
\usage{
expand_urls(
  urls_to_expand,
  warn = TRUE,
  agent = "longurl-r-package",
  seconds = 5,
  .progress = FALSE
)
}
\arguments{
\item{urls_to_expand}{character vector of URLs}

\item{warn}{show any warnings (API or otherwise) as messages}

\item{agent}{user agent to use (some sites switchup content based on user agents).
Defaults to "`longurl-r-package`".}

\item{seconds}{number of seconds to wait for a response until giving up. Cannot be <1ms.}

\item{.progress}{kept for legacy functionality but ignored}
}
\value{
a tibble/data frame with the orignial URLs in `orig_url`, expanded URLs in
       `expanded_url` and the HTTP `status_code` of the expanded URL. Completely
       invalid URLs result in a `NA` value for `expanded_url` & `status_code`.
}
\description{
Pass in a vector of URLs (ostensibly "short" URLs) and receive
a data frame of the original URLs and expanded URLs
}
\examples{
test_urls <- c("http://t.co/D4C7aWYIiA",
               "1.usa.gov/1J6GNoW",
               "ift.tt/1L2Llfr")
big_urls <- expand_urls(test_urls)
head(big_urls)
}
