% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lookupTable.R
\name{predict.lookupTable}
\alias{predict.lookupTable}
\title{Predictions from a look-up table}
\usage{
\method{predict}{lookupTable}(object, newdata, newparams = NULL, ...)
}
\arguments{
\item{object}{a fitted lookupTable object}

\item{newdata}{data.frame from which to evaluate predictions}

\item{newparams}{new parameters to use in evaluating predictions}

\item{...}{optional additional parameters.  None are used at present.}
}
\value{
a numeric vector of predicted values
}
\description{
\code{\link{predict}} method for \code{\linkS4class{lookupTable}} objects
}
\examples{
df.input <- cars
response <- 'dist'
feature.boundaries <- list(c(-Inf, 5, 10, 15, 20, 25, Inf))
features.con <- c('speed')
dist.table <- lookupTable(df.input, response, feature.boundaries, features.con)
df.test <- data.frame(speed = c(2, 23, 41, 5, 9, 8))
predict(dist.table, df.test)
}

