% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loonGrob.R
\name{get_model_display_order}
\alias{get_model_display_order}
\title{Get the Order of the Display}
\usage{
get_model_display_order(widget)
}
\arguments{
\item{widget}{An \code{l_plot} or \code{l_serialaxes} widget}
}
\description{
In \code{loon}, if points (in scatter plot) or lines
(in parallel or radial coordinate) are highlighted, the displayed order will be changed.
This function always reflects the current displayed order
}
\examples{
if(interactive()) {
  p <- l_plot(rnorm(10))
  get_model_display_order(p)
  p['selected'][c(1,3,5,7)] <- TRUE
  # The 1st, 3rd, 5th, 7th points will be drawn afterwards
  # to make sure that they are displayed on top
  get_model_display_order(p)
}
}
