% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{as.tags.lorem}
\alias{as.tags.lorem}
\title{Render placeholder text as HTML tags}
\usage{
\method{as.tags}{lorem}(x, wrapper = NULL, ...)
}
\arguments{
\item{x}{Object to be converted.}

\item{wrapper}{A function that takes a character string of a paragraph or
chunk of placeholder text and returns an \code{\link[htmltools:builder]{htmltools::tag()}}. By default,
lorem ipsum text is wrapped in \code{\link[htmltools:builder]{htmltools::p()}}.}

\item{...}{Any additional parameters.}
}
\value{
Returns an \code{\link[htmltools:tagList]{htmltools::tagList()}}.
}
\description{
Renders \code{\link[=ipsum]{ipsum()}} placeholder text as HTML tags using
\code{\link[htmltools:as.tags]{htmltools::as.tags()}}. By default, paragraphs are rendering \verb{<p>} tags with
\code{\link[htmltools:builder]{htmltools::p()}}, but you may provide your own paragraph \code{wrapper} function.
In general, you won't need to manually call this function, instead you can
just drop \code{\link[=ipsum]{ipsum()}} text into another \code{\link[htmltools:builder]{htmltools::tag()}}.
}
\examples{
htmltools::div(
  lorem::ipsum(paragraphs = 3)
)

htmltools::tags$ul(
  htmltools::as.tags(
    lorem::ipsum(paragraphs = 3, sentences = 1),
    wrapper = htmltools::tags$li
  )
)

}
