% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serial_position.R
\name{serial_position}
\alias{serial_position}
\title{Serial Position Calculator}
\usage{
serial_position(data, position, answer, key, scored, group.by = NULL)
}
\arguments{
\item{data}{a dataframe of the scored free recall that you would
like to calculate - use prop_correct_free() for best formatting.}

\item{position}{a column name in the dataframe that contains
answered position of each response in quotes (i.e., "column")}

\item{answer}{a column name of the answer given for that position
in the original dataframe.}

\item{key}{a vector containing the scoring key or data column name.
This column does not have to be included in the original dataframe.
We assume your answer key is in the tested position order. You should
not include duplicates in your answer key.}

\item{scored}{a column in the original dataframe indicating if the
participant got the answer correct (1) or incorrect (0).}

\item{group.by}{an optional argument that can be used to group the
output by condition columns. These columns should be in the original
dataframe and concatenated c() if there are multiple columns}
}
\value{
\item{DF_Serial}{A dataframe of the proportion correct for each
tested position by any optional grouping variables included.}
}
\description{
This function calculates the proportion correct of each item in the
serial position curve. Data should include the participant's answers
in long format (use arrange_data() in this package for help), the answer
key of the items in order, and a column that denotes the order a
participant listed each item. The function will then calculate
the items remembered within a window of 1 before or 1 after the
tested position. The first and last positions must be answered in the
correct place.
}
\details{
This output can then be used to create a serial position curve visualizations,
and an example can be found in our manuscript/vignettes.

Important: The code is written assuming group.by variables are
between subjects for an individual recall list.
If repeated measures are used (i.e., there are
multiple lists completed by each participant or multiple list versions),
you should use this function several times, once on each list/answer key.
}
\examples{

data(free_data)
data(answer_key_free2)

free_data <- subset(free_data,
 List_Type == "Cat_Recall_L1")

DF_long <- arrange_data(data = free_data,
 responses = "Response",
 sep = " ",
 id = "Username")

scored_output <- prop_correct_free(data = DF_long,
 responses = "response",
 key = answer_key_free2$Answer_Key,
 id = "Sub.ID",
 cutoff = 1,
 flag = TRUE,
 group.by = "Version")

serial_output <- serial_position(data = scored_output$DF_Scored,
 key = answer_key_free2$Answer_Key,
 position = "position",
 scored = "Scored",
 answer = "Answer",
 group.by = "Version")

 head(serial_output)

}
\keyword{correct}
\keyword{free}
\keyword{position}
\keyword{proportion}
\keyword{recall}
\keyword{scoring}
\keyword{serial}
