% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_gen.R
\name{cov_gen}
\alias{cov_gen}
\title{Generation of covariance matrices}
\usage{
cov_gen(pr_grp_1, n_fac, n_ind, Lambda = 0:1)
}
\arguments{
\item{pr_grp_1}{proportion of observations in group 1. Can be a scalar or a
vector}

\item{n_fac}{number of factors}

\item{n_ind}{number of indicators per factor}

\item{Lambda}{either a matrix containing the factor loadings or a vector
containing the lower and upper limits for a randomly-generated Lambda
matrix}
}
\value{
A list containing three covariance matrices: vcov_yxw, vcov_yxz and
vcov_yfz
}
\description{
Construct covariance matrices for the generation of simulated test data.
}
\examples{
 vcov <- cov_gen(pr_grp_1 = .5, n_fac = 3, n_ind = 2)
 str(vcov)
}
