% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model.R
\docType{methods}
\name{CluesModel}
\alias{CluesModel}
\alias{CluesModel,ObsLulcRasterStack,ExpVarRasterList,PredictiveModelList-method}
\title{Create a CluesModel object}
\usage{
CluesModel(obs, ef, models, ...)


  \S4method{CluesModel}{ObsLulcRasterStack,ExpVarRasterList,PredictiveModelList}(obs,
  ef, models, time, demand, hist, mask, neighb = NULL, elas, rules = NULL,
  nb.rules = NULL, params, output = NULL, ...)
}
\arguments{
\item{obs}{an ObsLulcRasterStack}

\item{ef}{an ExpVarRasterList object}

\item{models}{a PredictiveModelList object}

\item{\dots}{additional arguments (none)}

\item{time}{numeric vector containing timesteps over which simulation will
occur}

\item{demand}{matrix with demand for each land use category in terms of number
of cells to be allocated. The first row should be the number of cells
allocated to the initial observed land use map (i.e. the land use map for
time 0)}

\item{hist}{RasterLayer containing land use history (values represent the
number of years the cell has contained the current land use category)}

\item{mask}{RasterLayer containing binary values where 0 indicates cells
that are not allowed to change}

\item{neighb}{an object of class NeighbRasterStack}

\item{elas}{numeric indicating the elasticity of each land use category to
change. Elasticity varies between 0 and 1, with 0 indicating a low
resistance to change and 1 indicating a high resistance to change}

\item{rules}{matrix with land use change decision rules}

\item{nb.rules}{numeric with neighbourhood decision rules}

\item{params}{list with model parameters}

\item{output}{either a RasterStack containing output maps or NULL}
}
\value{
A CluesModel object.
}
\description{
Methods to create a \code{CluesModel} object to supply to
\code{\link{allocate}}.
}
\details{
The \code{params} argument is a list of parameter values which should contain
the following components:

\describe{
  \item{\code{jitter.f}}{Parameter controlling the amount of perturbation
    applied to the probability surface prior to running the CLUE-S iterative
    algorithm. Higher values result in more perturbation. Default is 0.0001}
  \item{\code{scale.f}}{Scale factor which controls the amount by which
    suitability is increased if demand is not met. Default is 0.0005}
  \item{\code{max.iter}}{The maximum number of iterations in the simulation}
  \item{\code{max.diff}}{The maximum allowed difference between allocated and
    demanded area of any land use type. Default is 5}
  \item{\code{ave.diff}}{The average allowed difference between allocated and
    demanded area. Default is 5}
}

Note that, in order to achieve convergence, it is likely that some adjustment
of these parameters will be required.
}
\examples{

## see lulcc-package examples
}
\references{
Verburg, P.H., Soepboer, W., Veldkamp, A., Limpiada, R., Espaldon, V., Mastura,
S.S. (2002). Modeling the spatial dynamics of regional land use: the CLUE-S
model. Environmental management, 30(3):391-405.
}
\seealso{
\code{\link{CluesModel-class}}, \code{\link{allocate}}
}
