% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionList.R
\name{PredictionList}
\alias{PredictionList}
\title{Create a PredictionList object}
\usage{
PredictionList(models, newdata, ...)
}
\arguments{
\item{models}{a PredictiveModelList object}

\item{newdata}{a data.frame containing new data}

\item{\dots}{additional arguments to \code{ROCR::\link[ROCR]{prediction}}}
}
\value{
A \code{PredictionList} object.
}
\description{
This function creates a \code{ROCR::\link[ROCR]{prediction}} object for each
predictive model in a \code{PredictiveModelList} object. It should be used with
\code{\link{PerformanceList}} to evaluate multiple models with exactly the
same criteria while keeping track of which model corresponds to which land use
category.
}
\examples{

## see lulcc-package examples
}
\references{
Sing, T., Sander, O., Beerenwinkel, N., Lengauer, T. (2005).
ROCR: visualizing classifier performance in R. Bioinformatics
21(20):3940-3941.
}
\seealso{
\code{link{PerformanceList}}, \code{ROCR::\link[ROCR]{prediction}}
}
