% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{lag.data.frame}
\alias{lag.data.frame}
\title{Lag a variable}
\usage{
\method{lag}{data.frame}(x, var, by = NULL, new_var = NULL, last_obs = FALSE, ...)
}
\arguments{
\item{x}{data.frame}

\item{var}{variable to be lagged}

\item{by}{variable for grouped lagged version}

\item{new_var}{name of new lagged variable}

\item{last_obs}{\code{TRUE}retrieves the last observation per group.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
data.frame
}
\description{
creates lagged version of an existing variable.
}
\details{
This is often encountered in time-related analysis.
In a lagged variable, values from earlier points in time are placed in later
rows of dataset.
}
\note{
Before using \code{lagRows}, the dataset needs to be sorted by a id variable
or similar variable.
}
\examples{

set.seed(100)
## create a dataset with dates
x <- data.frame(
    hospid = 1:100,
    docid = round(runif(100, 1, 10)),
    dis_date = formatDate(runif(100, 42700, 42800))
)

## lagged dis_date, not specifed "by"
lag(x, dis_date)

\dontrun{
## lagged dis_date by docid
## first we need to sort
y <- x[order(x$docid), ]
y

## lag dates within groups
lag(y, dis_date, by = docid, new_var = lag_date)
lag(y, dis_date, by = docid, lag_date, TRUE)
}

}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
