% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_multiple_macrosyntenies.R
\name{reorder_multiple_macrosyntenies}
\alias{reorder_multiple_macrosyntenies}
\title{Reorder the chromosomes of two or more species before plotting}
\usage{
reorder_multiple_macrosyntenies(orthologs_df)
}
\arguments{
\item{orthologs_df}{dataframe. orthologs with genomic coordinates loaded with load_orthologs()}
}
\value{
A dataframe object
}
\description{
This is a function to reorder an orthologs_df, same as reorder_macrosynteny,
but it handles tables with more than 2 species.
}
\examples{
# basic usage of reorder_macrosynteny : 

orthologs_table <- system.file("extdata","my_orthologs.tab",package="macrosyntR")

my_orthologs <- read.table(orthologs_table,header=TRUE)

my_orthologs_reordered <- reorder_multiple_macrosyntenies(my_orthologs)

}
\seealso{
\code{\link[=load_orthologs]{load_orthologs()}}

\code{\link[=compute_macrosynteny]{compute_macrosynteny()}}

\code{\link[=reorder_macrosynteny]{reorder_macrosynteny()}}
}
