% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen.r
\name{eigen}
\alias{eigen}
\alias{eigen,madness-method}
\title{Spectral Decomposition of a Matrix}
\usage{
\S4method{eigen}{madness}(x, symmetric, only.values = FALSE, EISPACK = FALSE)
}
\arguments{
\item{x}{\code{madness} object representing a numeric matrix
whose spectral decomposition is to be computed.}

\item{symmetric}{if \code{TRUE}, the matrix is assumed to be symmetric
    (or Hermitian if complex) and only its lower triangle (diagonal
    included) is used.  If \code{symmetric} is not specified,
    \code{\link[base]{isSymmetric}(x)} is used.}

\item{only.values}{if \code{TRUE}, only the eigenvalues are computed
    and returned, otherwise both eigenvalues and eigenvectors are
    returned.}

\item{EISPACK}{logical. Defunct and ignored.}
}
\value{
a list with components
\describe{
\item{values}{a \code{madness} object of a vector containing
the \eqn{p} eigenvalues of \code{x}, sorted in \emph{decreasing} order,
according to \code{Mod(value)} in the assymetric case when they might
be complex (even for real matrices). For real asymmetric matrices
the vector will be complex only if complex conjugate pairs of eigenvalues are 
detected.}
\item{vectors}{either a \eqn{p \times p}{p * p} matrix whose columns contain the
eigenvectors of \code{x} or \code{NULL} if \code{only.values} is 
\code{TRUE}. The vectors are normalized to unit length.

Recall that the eigenvectors are only defined up to a constant: 
even when the length is specified they are still only defined up to a 
scalar of modulus one (the sign for real matrices).  
If \code{r <- eigen(A)}, and \code{V <- r$vectors; lam <- r$values}, then
\deqn{A = V Lmbd V^{-1}}{A = V Lmbd V^(-1)}
(up to numerical fuzz), where \code{Lmbd =diag(lam)}.
}
}
}
\description{
Computes eigenvalues and eigenvectors of numeric (double, integer, logical) or 
complex \code{madness} matrices.
}
\details{
The singular value decomposition of the matrix \eqn{X}{X} is
\deqn{X = U D V',}{X = U D V',}
where \eqn{U} and \eqn{V} are orthogonal, \eqn{V'} is \eqn{V}
transposed, and \eqn{D} is a diagonal matrix with the singular
values on the diagonal.
}
\references{
Izenman, Alan Julian. "Reduced-Rank Regression for the Multivariate Linear
Model." Journal of Multivariate Analysis 5, pp 248-264 (1975).
\url{https://www.sciencedirect.com/science/article/pii/0047259X75900421}

Kato, Tosio. "Perturbation Theory for Linear Operators."
Springer (1995).
\url{https://www.maths.ed.ac.uk/~v1ranick/papers/kato1.pdf}
}
\seealso{
\code{\link{eigen}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
