% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMadratMessage.R
\name{getMadratMessage}
\alias{getMadratMessage}
\title{getMadratMessage}
\usage{
getMadratMessage(name = NULL, fname = NULL)
}
\arguments{
\item{name}{The category in which the message should be stored}

\item{fname}{function name. If specified only messages belonging to the
functions history will be returned (this includes entries from the function
itself, but also entries from functions which were called by this function).}
}
\description{
Read a madrat message from the madrat environment. The madrat environment
behaves similar like global options, except that 1) messages will also
be stored in cache files and restored when a cache file is being loaded and
2) messages are always stored in lists with messages split by function calls
where the message was triggered.
}
\examples{
putMadratMessage("test", "This is a toast", fname = "readTau")
getMadratMessage("test", fname = "calcTauTotal")
}
\seealso{
\code{\link{getMadratMessage}}
}
\author{
Jan Philipp Dietrich
}
