% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pucAggregate.R
\name{pucAggregate}
\alias{pucAggregate}
\title{pucAggregate}
\usage{
pucAggregate(
  puc,
  regionmapping = getConfig("regionmapping"),
  ...,
  renv = TRUE,
  strict = FALSE
)
}
\arguments{
\item{puc}{path to a puc-file}

\item{regionmapping}{region mapping to be used for aggregation.}

\item{...}{(Optional) Settings that should be changed in addition. NOTE:
which settings can be modified varies from puc to puc. Allowed settings are
typically listed in the file name of the puc file after the revision number.}

\item{renv}{Boolean which determines whether data should be aggregated from
within a renv environment (recommended) or not. If activated, \code{renv}
will check which packages in which versions were used to create the puc file,
download, install and load these packages and run the aggregation with them.
Otherwise, the packages in the currently used environment are being used.}

\item{strict}{Boolean or NULL which allows to trigger a strict mode. During strict mode
warnings will be taken more seriously and will cause 1. to have the number of
warnings as prefix of the created tgz file and 2. will prevent \code{retrieveData}
from creating a puc file. If set to NULL the setting will be read from the puc file.}
}
\description{
Function which takes a puc-file ("portable unaggregated collection") as created
via \code{\link{retrieveData}} and computes the corresponding aggregated
collection with the provided arguments (e.g. the provided region mapping).
The resulting tgz-file containing the collection will be put to the
madrat outputfolder as defined in \code{getConfig("outputfolder")}.
}
\examples{
\dontrun{
pucAggregate("rev1_example.puc", regionmapping = "regionmappingH12.csv")
}
}
\seealso{
\code{\link{retrieveData}},\code{\link{localConfig}}
}
\author{
Jan Philipp Dietrich
}
